<?php
require_once 'koneksi.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $role = $_POST['role'];
    $username = $_POST['username'];
    $password = $_POST['password'];

    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    $sql = "INSERT INTO users (username, password, role) VALUES (?, ?, ?)";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "sss", $username, $hashed_password, $role);

    if (mysqli_stmt_execute($stmt)) {
        echo "<script>alert('Registrasi berhasil! Silakan login.'); window.location='login.php';</script>";
    } else {
        if (mysqli_errno($conn) == 1062) {
            echo "<script>alert('Registrasi gagal! Username sudah digunakan.');</script>";
        } else {
            echo "<script>alert('Registrasi gagal! Terjadi kesalahan.');</script>";
        }
    }
    mysqli_stmt_close($stmt);
}
// mysqli_close($conn); // Ditutup agar tidak error saat di-include di login.php
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Register</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="style/style_login.css">
</head>
<body>
    <div class="container mt-5" style="max-width: 500px;">
        <h3 class="text-center mb-4">Daftar Akun Baru</h3>
        <form method="POST">
            <div class="mb-3">
                <select class="form-select" name="role" required>
                    <option value="" disabled selected>Pilih Jenis Akun</option>
                    <option value="petugas">Petugas</option>
                    <option value="masyarakat">customer</option>
                </select>
            </div>
            <div class="mb-3">
                <input type="text" class="form-control" name="username" placeholder="Username" required />
            </div>
            <div class="mb-3">
                <input type="password" class="form-control" name="password" placeholder="Password" required />
            </div>
            <button type="submit" class="btn btn-primary w-100">Daftar</button>
            <p class="mt-3 text-center">Sudah punya akun? <a href="login.php">Login</a></p>
        </form>
    </div>
</body>
</html>