const laporanList = JSON.parse(localStorage.getItem("pengaduanList")) || [];
const statusDiv = document.getElementById("statusLaporan");

if (laporanList.length === 0) {
  statusDiv.innerHTML = `<p class="text-center">Belum ada laporan yang dikirim.</p>`;
} else {
  let html = `
    <table class="table table-bordered table-striped">
      <thead class="table-dark">
        <tr>
          <th>No</th>
          <th>Nama Pelapor</th>
          <th>Isi Pengaduan</th>
          <th>Status Verifikasi</th>
          <th>Status Validasi</th>
          <th>Tanggapan Admin</th>
        </tr>
      </thead>
      <tbody>
  `;

  laporanList.forEach((laporan, index) => {
    html += `
      <tr>
        <td>${index + 1}</td>
        <td>${laporan.namaPelapor}</td>
        <td>${laporan.isiPengaduan}</td>
        <td>${laporan.verifikasi ? "✅ Diverifikasi" : "❌ Belum"}</td>
        <td>${laporan.validasi ? "✅ Divalidasi" : "❌ Belum"}</td>
        <td>${laporan.tanggapan ? laporan.tanggapan : "-"}</td>
      </tr>
    `;
  });

  html += `</tbody></table>`;
  statusDiv.innerHTML = html;
}
