function generateLaporan() {
  const data = JSON.parse(localStorage.getItem("pengaduanList")) || [];

  if (data.length === 0) {
    alert("Tidak ada data pengaduan untuk digenerate.");
    return;
  }

  let laporan = "Laporan Pengaduan Masyarakat\n\n";
  data.forEach((item, index) => {
    laporan += `
Pengaduan #${index + 1}
-------------------------
Nama Pelapor     : ${item.namaPelapor}
Alamat Pelapor   : ${item.alamatPelapor}
No. HP           : ${item.noTelpHp}
Email            : ${item.email}
Nama Dilaporkan  : ${item.namaDilaporkan}
Isi Pengaduan    : ${item.isiPengaduan}
Tanggal          : ${item.tanggal}

`;
  });

  const blob = new Blob([laporan], { type: "text/plain;charset=utf-8" });
  const url = URL.createObjectURL(blob);
  const a = document.createElement("a");
  a.href = url;
  a.download = "Laporan_Pengaduan.txt";
  a.click();
  URL.revokeObjectURL(url);
}