<?php
session_start();

// Data dummy pengguna
$users = [
    ['username' => 'admin', 'password' => 'admin123', 'role' => 'admin'],
    ['username' => 'petugas', 'password' => 'petugas123', 'role' => 'petugas'],
    ['username' => 'masyarakat', 'password' => 'masyarakat123', 'role' => 'masyarakat'],
];

// Cek jika form login disubmit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $role = $_POST['role'];
    $username = $_POST['username'];
    $password = $_POST['password'];

    $found = false;
    foreach ($users as $user) {
        if ($user['username'] === $username && $user['password'] === $password && $user['role'] === $role) {
            $_SESSION['username'] = $username;
            $_SESSION['role'] = $role;
            $found = true;
            break;
        }
    }

    if ($found) {
        // Redirect sesuai role
        if ($role === 'admin') {
            header('Location: administator.html');
        } elseif ($role === 'petugas') {
            header('Location: petugas.html');
        } else {
            header('Location: masyarakat.html');
        }
        exit;
    } else {
        $error = "Login gagal! Periksa username, password, dan jenis login.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Login</title>
  <link rel="stylesheet" href="/css/bootstrap.min.css" />
  <link rel="stylesheet" href="style_login.css" />
</head>
<body>
  <div class="container mt-5">
    <h3 class="text-center mb-4">Login</h3>

    <?php if (isset($error)): ?>
      <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">
      <div class="mb-3">
        <select class="form-control" name="role" required>
          <option value="" disabled selected>Pilih Jenis Login</option>
          <option value="admin">Administrator</option>
          <option value="petugas">Petugas</option>
          <option value="masyarakat">Masyarakat</option>
        </select>
      </div>

      <div class="mb-3">
        <input type="text" class="form-control" name="username" placeholder="Username" required />
      </div>

      <div class="mb-3">
        <input type="password" class="form-control" name="password" placeholder="Password" required />
      </div>

      <button type="submit" class="btn btn-primary w-100">Login</button>

      <p class="mt-3 text-center">
        Belum punya akun? <a href="register.php">Daftar</a>
      </p>
    </form>
  </div>
</body>
</html>
