<?php

require 'koneksi.php'; // Hubungkan ke database

$page_title = "Administrator - Desak_U";
$logo_text = "Welcome to Desak_U";
$main_location = "-------";
$main_headline = "Admin<br>Said";
$main_description = "Bersatu bukan hanya karena satu tempat tinggal, tapi karena satu tujuan: membangun masa depan yang lebih baik bersama.";
$background_image_url = "foto/bg.jpg";

$cards_data = [
    [
        "title" => "Total Laporan Masuk",
        "value" => "1,250",
        "image_url" => "foto/bg.jpg",
        "is_active" => true
    ],
    [
        "title" => "Laporan Diproses",
        "value" => "980",
        "image_url" => "foto/bg1.jpg",
        "is_active" => false
    ],
    [
        "title" => "Laporan Selesai",
        "value" => "270",
        "image_url" => "foto/bg2.jpg",
        "is_active" => false
    ],
];
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <link rel="stylesheet" href="style/style_administator.css">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <style>
        .main-container {
            background-image: linear-gradient(rgba(0, 0, 0, 0.4), rgba(0, 0, 0, 0.4)), url('<?php echo htmlspecialchars($background_image_url); ?>');
        }
    </style>
</head>

<body>
    <div class="main-container">
        <header>
            <div class="logo">
                <i class='bx bxs-dashboard'></i>
                <span><?php echo htmlspecialchars($logo_text); ?></span>
            </div>
            <nav>
                <ul>
                    <li><a href="#" class="active">HOME</a></li>
                    <li><a href="#">Daftar Sepatu</a></li>
                    <li><a href="#">Validasi</a></li>
                    <li><a href="#">Tanggapan</a></li>
                    <li><a href="#">laporan Keuangan</a></li>
                </ul>
            </nav>
            <div class="header-icons">
                <i class='bx bx-search'></i>
                <a href="login_web.php" class="logout-link" title="Logout">
                    <i class='bx bx-log-out-circle'></i>
                </a>
            </div>
        </header>
        <main>
            <div class="content-left">
                <p class="location"><?php echo htmlspecialchars($main_location); ?></p>
                <h1><?php echo $main_headline; ?></h1>
                <p class="description"><?php echo htmlspecialchars($main_description); ?></p>
            </div>
            <div class="content-right">
                <div class="destination-cards">
                    <?php
                    foreach ($cards_data as $card) {
                        $card_class = $card['is_active'] ? 'card active' : 'card';
                        echo '<div class="' . $card_class . '">';
                        echo '  <img src="' . htmlspecialchars($card['image_url']) . '" alt="' . htmlspecialchars($card['title']) . '">';
                        echo '  <div class="card-content">';
                        echo '      <p>' . htmlspecialchars($card['title']) . '</p>';
                        echo '      <h3>' . htmlspecialchars($card['value']) . '</h3>';
                        echo '  </div>';
                        echo '</div>';
                    }
                    ?>
                </div>
                <div class="carousel-nav">
                    <div class="nav-arrows">
                        <button id="prev-btn"><i class='bx bx-chevron-left'></i></button>
                        <button id="next-btn"><i class='bx bx-chevron-right'></i></button>
                    </div>
                    <div class="pagination">
                        <span class="page-number">01</span>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script src="js/script_admin.js"></script>
</body>

</html>